#!/bin/bash
#thx Eddward for arch detection

configdir=~/.familyfarm
configfile=${configdir}/appconfig.cfg

echo "Starting Family Farm..."
#language autodetection
if [ ! -f ${configfile} ] ; then
	echo "Config file not found,"
	echo "  autodetecting language, system locale is ${LANG}"
	case $(echo "${LANG}" | cut -d_ -f1) in
		cs|sk) gamelang="CS-CZ";;
		pl)    gamelang="PL-PL";;
		de)    gamelang="DE-DE";;
		it)    gamelang="IT-IT";;
		fr)    gamelang="FR-FR";;
		*)     gamelang="EN-UK";;
	esac
	echo "  using ${gamelang} as game language"
	if [ ${gamelang} != "EN-UK" ] ; then
		if [ ! -d ${configdir} ] ; then 
			echo "  config dir not found either"
			mkdir ${configdir} 
		fi 
		echo "  writing config file"
		echo "[user]" > ${configfile}
		echo "language=${gamelang}" >> ${configfile}
	else
		echo "  no need to create config file"
	fi
fi

prog_dir=$(cd "$(dirname "$0")"; pwd)
prog_arch=$(getconf LONG_BIT)
prog_arch_dir="$prog_dir/bin/$prog_arch"

echo "Found $prog_arch-bit system, launching \"$prog_arch_dir/Farm\"."
if ! [ -x "$prog_arch_dir/Farm" ] ; then
	echo "Could not find \"$prog_arch_dir/Farm\"."
	echo "Check your installation directory."
	exit 1
fi

cd "$prog_arch_dir"
exec ./Farm
