#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform sampler2D color_map1;
uniform sampler2D color_map2;
uniform sampler2D color_map3;

uniform vec4      surface_diffuse_colour;
uniform vec4      blend;

varying vec4      _colour;
varying vec4      _uv0;
varying vec4      _uv1;

/* ****************************************************************************************************************** */
void main()
{
	vec4 color_diffuse;
	vec4 color_overlay;
	vec4 color_alphasrc;
	vec3 base;
	vec3 overlay;
	
	color_diffuse =  texture2D(color_map1, _uv0.xy);
	color_overlay =  texture2D(color_map2, _uv1.xy);
	color_alphasrc = texture2D(color_map3, _uv0.xy);
	
	base = ((1.0-color_diffuse.aaa) * surface_diffuse_colour.rgb)                // colored base texture
	     + vec3(pow(color_diffuse.a, 0.7))                                       // lighten with alpha
	     - ((1.0-color_diffuse.rgb) * (1.0 - 0.25 * surface_diffuse_colour.rgb)) // darken previously lightened
	     - (1.0-color_alphasrc.rgb);                                             // darken with alphasrc rgb
	overlay = 1.0 - (color_overlay.rgb * _colour.rgb * blend.x * 0.15);
	
	gl_FragColor = vec4(base * overlay, color_alphasrc.a * _colour.a * surface_diffuse_colour.a);
}
