#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform   mat4 world_view_proj;
uniform   mat4 world;
uniform   vec4 cloudparams;

attribute vec4 vertex;
attribute vec3 normal;
attribute vec4 colour;
attribute vec4 uv0;

varying   vec4 _colour;
varying   vec4 _uv0;
varying   vec4 _uv1;
varying   vec4 _uv2;
varying   vec4 _world_position;
varying   vec4 _world_normal;

void main()
{
	
	_world_position = world * vertex;
	_world_normal   = normalize(world * vec4(normal, 0.0));
	
	_colour = colour;
	_uv0.xy = uv0.xy;
	_uv1.xy = (_world_position.xz * cloudparams.zz) + cloudparams.xy; // mraky
	_uv2.xy = _world_position.xz * 0.05;                              // detail
	
	gl_Position    = world_view_proj * vertex;
}

