#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform vec4      surface_diffuse_colour;
uniform sampler2D color_map1;

varying vec4      _colour;
varying vec4      _uv0;

void main()
{
	vec4 color_diffuse;
	vec4 highlight_color;
	
	color_diffuse =  texture2D(color_map1, _uv0.xy);
	highlight_color= vec4(0.55, 0.5, 0.35, clamp(0.3 + color_diffuse.a, 0.0, 1.0));
	
	gl_FragColor = _colour * surface_diffuse_colour * highlight_color - (1.0 - _colour);
}

