#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform vec4 camera_position;
uniform vec4 rimcolor;

varying vec4 _world_normal;
varying vec4 _world_position;

void main()
{
	vec4 solidcolor;
	vec4 camera_direction;
	float lighting;
	
	solidcolor = vec4(0.3, 0.1, 0.2, 0.3);
	camera_direction = normalize(camera_position - _world_position);
	lighting = dot(camera_direction, _world_normal);

	gl_FragColor = (1.0 - lighting) * rimcolor + solidcolor;
}
