#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

#ifdef INSTANCING
	uniform vec4 world_3x4_array[240];
	uniform mat4 view_proj;
#else
	uniform mat4 world_view_proj;
#endif

#ifdef PERVERTEX
	uniform vec4 surface_diffuse_colour;
#endif

attribute vec4 vertex;
attribute vec4 colour;
#ifdef INSTANCING
	attribute vec4 uv0;
#endif

varying   vec4 _colour;

void main()
{
#ifdef PERVERTEX
	_colour = colour + surface_diffuse_colour.aaaa;
	_colour.rgb += surface_diffuse_colour.rgb * (1.0 - colour.rgb);
#else
	_colour = colour;
#endif
	
#ifdef INSTANCING
	vec3 transformed_pos;
	vec4 matrix_row;
	int  index;
	
	index = int(uv0.x) * 3;
	for (int row = 0; row < 3; ++row)
	{
		matrix_row = world_3x4_array[index + row];
		transformed_pos[row] = dot(matrix_row, vertex);
	}
	
	gl_Position = view_proj * vec4(transformed_pos, 1.0);
#else
	gl_Position = world_view_proj * vertex;
#endif


}
