#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform vec4      surface_diffuse_colour;
uniform sampler2D color_map1;
uniform sampler2D color_map2;

varying vec4      _colour;
varying vec4      _uv0;
varying vec4      _uv1;
varying vec4      _uv2;

void main()
{
	vec4 color_diffuse1;
	vec4 color_diffuse2;
	vec4 mixed;
	vec4 result;
	
	color_diffuse1 = texture2D(color_map1, _uv0.xy);
	color_diffuse2 = texture2D(color_map2, _uv1.xy) * _uv2.y;
	
	mixed = mix(color_diffuse1, surface_diffuse_colour, _uv2.x);
	
	result = mixed * _colour + color_diffuse2.gggg;
	result.a *= surface_diffuse_colour.a;
	
	gl_FragColor = result;
}
