#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

#ifdef FUR
	uniform float offset;
	uniform float passnum;
#endif
#ifdef VARIABLEFUR
	uniform vec4  camdir;
#endif

uniform     mat4  world_view_proj;

attribute   vec4  vertex;
attribute   vec4  colour;
attribute   vec4  uv0;
#ifdef FUR
attribute   vec3  normal;
#endif

varying     vec4  _colour;
varying     vec4  _uv0;

void main()
{
	vec4 _position;
	
	_position = vertex;
#ifdef FIXEDFUR
	_position.xyz += offset * normal.xyz * (passnum);
#endif
#ifdef VARIABLEFUR
	_position.xyz += offset * length(camdir) * normal.xyz * (passnum);
#endif
	
	_colour = colour;
	_uv0.xy = uv0.xy;
	
	gl_Position = world_view_proj * _position;
}

