#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform   mat4 world_view_proj;
uniform   mat4 world;
uniform   vec4 campos;
uniform   vec2 offset;
uniform   vec4 passnum;

attribute vec4 vertex;
attribute vec3 normal;
attribute vec4 colour;
attribute vec4 uv0;

varying   vec4 _colour;
varying   vec4 _uv0;

void main()
{
	vec4 _position;
	float dist;
	
	_colour = vec4(colour.rgb, 1.0);
	_uv0.xy = uv0.xy;
	
	dist = (offset.x * passnum.x) * distance(campos.xyz, vertex.xyz);
	
	_position = vertex;
	_position.xyz += dist * (offset.yyy * normal.xyz);
	
	gl_Position = world_view_proj * _position;
}
