#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

//#define SIMPLE=1
//#define PERVERTEX 1

#ifdef FLORA
	#ifndef SIMPLE
		uniform vec4 time1;
		uniform vec4 time2;
		uniform float oldness;
		uniform float height;
	#endif
#endif

#ifdef LEAVES
	uniform vec4 blend;
#endif

#ifdef FUR
	uniform float offset;
	uniform float passnum;
#endif

#ifdef INSTANCING
	#ifdef WHEAT
		uniform mat4 world;
	#endif
	uniform vec4 world_3x4_array[240];
	uniform mat4 view_proj;
#else
	uniform mat4 world_view_proj;
	uniform mat4 world;
#endif

#ifdef PERVERTEX
	uniform vec4 surface_ambient_colour;
	uniform vec4 surface_diffuse_colour;
	uniform vec4 light_ambient;
	uniform vec4 light_diffuse;
	uniform vec4 light_direction;
#endif

attribute vec4 vertex;
attribute vec3 normal;
attribute vec4 colour;
attribute vec4 uv0;
#ifdef INSTANCING
	attribute vec4 uv1;
#endif

varying   vec4 _colour;
varying   vec4 _uv0;
#ifdef LEAVES
	varying   vec4 _uv1;
#endif
#ifdef PERVERTEX
	varying    vec4 _diffuse;
#else // PERPIXEL
	varying    vec3 _world_position;
	varying    vec3 _world_normal;
#endif

void main()
{
#ifdef PERVERTEX
	vec3 _world_position;
	vec3 _world_normal;
#endif
	
	vec4 _position;
	
	_position = vertex;
	
#ifdef FUR
	_position.xyz += offset * normal.xyz * (passnum);
#endif
	
#ifdef INSTANCING
	vec3 transformed_pos;
	vec3 transformed_normal;
	vec4 normal4 = vec4(normal.xyz, 0);
	int index = int(uv1.x) * 3;
	for (int row = 0; row < 3; ++row)
	{
		vec4 matrix_row = world_3x4_array[index + row];
		transformed_pos[row] = dot(matrix_row, _position);
		transformed_normal[row] = dot(matrix_row, normal4);
	}
	
	_world_position = transformed_pos;
	_position = view_proj * vec4(transformed_pos, 1);
#else
	_position = world_view_proj * _position;
#endif
	
	_colour = colour;
	
#ifdef WHEAT
	#ifndef SIMPLE   
		vec4 position2;
		
		_position.x += _colour.a * time1.y * oldness * 0.07;;
		_position.y += _colour.a * time2.z * oldness * 0.007;;
		if (height != 0.0)
		{
			position2 = world * vertex;
			float fader = clamp(position2.y - height, -0.05, 0.0) * 20.0;
			_colour = min(colour + fader, 1.0);
		}
	#endif
	_colour.a = 1.0;
#endif

#ifdef TREE
	#ifndef SIMPLE
		float ground_level;
		
		ground_level = max(0.0, _position.y);
		_position.x += colour.a * time1.y * oldness * ground_level * 0.006;
		_position.y += colour.a * time2.z * oldness * ground_level * 0.002;
	#endif
	_colour.a = 1.0;
#endif

#ifdef FLOWER
	#ifndef SIMPLE
		_position.x += colour.a * time1.y * oldness * 0.07;
		_position.y += colour.a * time2.z * oldness * 0.007;
	#endif
	_colour.a = 1.0;
#endif
	
#ifdef INSTANCING
	_world_normal = normalize(transformed_normal);
#else
	_world_position = (world * _position).xyz;
	_world_normal = normalize(world * vec4(normal, 0)).xyz;
#endif

	_uv0.xy = uv0.xy;
	
#ifdef LEAVES
    _uv1.xy = vec2((blend + colour.a) - (uv0.x * 0.001));
    _colour.a = 1.0;
#endif

#ifdef PERVERTEX
	float lighting;
	vec3 diffuse;
	
	lighting =  max(0.0, dot(light_direction.xyz, _world_normal.xyz));
	
	// trochu znasilni difuzni cast osvetleni
	lighting = lighting * 1.1 - 0.05;
	
	diffuse  = (light_ambient.rgb * surface_ambient_colour.rgb) + (lighting * light_diffuse.rgb);
	
	_diffuse.rgb = min(diffuse, 1.0);
	_diffuse.a = surface_diffuse_colour.a;
#endif

	gl_Position = _position;
}
