#ifdef GL_ES
#version 100
precision mediump int;
precision mediump float;
#endif

uniform   mat4  world_view_proj;
uniform   float time;

attribute vec4  vertex;
attribute vec4  colour;
attribute vec4  uv0;

varying   vec4  _colour;
varying   vec4  _uv0;
varying   vec4  _uv1;
varying   vec4  _uv2;

void main()
{
	_colour = colour * vec4(1.0, 1.0, 1.0, 0.6);
	
	_uv0.xy = vec2(uv0.x * 2.2 + time, uv0.y * 0.9 + time);
	_uv1.xy = uv0.xy * 2.0 - time;
	_uv2.x = 1.0 - colour.a;
	_uv2.y = colour.a * (2.5 * _uv2.x + 0.1);
	
	gl_Position = world_view_proj * vertex;
}

